﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace FinalTest
{
    class Program
    {
        static void Main(string[] args)
        {
            Dokument d = new Dokument();

            Paragraf p1 = new Paragraf("Molimo pametne i poštene da čuvaju zdravlje i ne gube nadu. Za svaki slučaj. Ako nam niko drugi ne pomogne.");
            Recenica r1 = new Recenica("Deco, možete misliti kakav je život kada je od kolevke pa do groba najlepše đačko doba");
            Recenica r2 = new Recenica("Više je znanja i veštine (inteligencije, duha, mašte i ukusa) uložila Koka-kola za propagandu svoje obojene i zašećerene vode, nego škola za slavu i veličanje čitanja i pisanja.");
            Pravougaonik pr = new Pravougaonik("crvena", 1, 2, 1, 2);

            d.AddElement(p1);
            d.AddElement(r1);
            d.AddElement(r2);
            d.AddElement(pr);

            Console.WriteLine("ToString:");
            Console.WriteLine();
            Console.WriteLine(d.ToString());

            Console.WriteLine("Tekst:");
            Console.WriteLine();
            d.PrintText();

            int br = 0;
            foreach (TekstualniElement t in d.GetTextElements())
            {
                string temp = t.GetText();
                for(int i = 0; i < temp.Length; i++)
                {
                    if (temp[i] == 'a' || temp[i] == 'A')
                    {
                        br++;
                    }
                }
            }

            Console.WriteLine("\nBroj slova a / A : " + br);

            Console.ReadKey();
        }
    }

    class ElementUDokumentu
    {
        string Vrsta;
        public string vrsta { get { return Vrsta; } set { Vrsta = value; } }

        public ElementUDokumentu(string v)
        {
            vrsta = v;
        }

        public override string ToString()
        {
            return vrsta;
        }
    }

    abstract class TekstualniElement:ElementUDokumentu
    {
        public TekstualniElement(string v):base(v){}

        abstract public string GetText();
    }

    class Recenica:TekstualniElement
    {
        string Tekst;
        public string tekst { get { return Tekst; } set { Tekst = value; } }

        public Recenica(string r):base("recenica")
        {
            tekst = r;
            if (tekst.IndexOf('.') >= 0)
            {
                tekst = tekst.Substring(0, tekst.IndexOf('.'));
            }
        }

        public override string GetText()
        {
            return tekst + ".";
        }

        public override string ToString()
        {
            return vrsta + ": " + tekst + ".";
        }
    }

    class Paragraf:TekstualniElement
    {
        StringBuilder Tekst;
        public StringBuilder tekst { get { return Tekst; } set { Tekst = value; } }


        public Paragraf(string t):base("paragraf")
        {
            tekst = new StringBuilder();
            if (t.IndexOf("\n") >= 0)
            {
                tekst.Append(t.Substring(0, t.IndexOf("\n")));
            }
            else
            {
                tekst.Append(t);
            }
            
        }

        public void DodajTekst(string s)
        {
            tekst.Append(s);
        }

        public void DodajTekst(Recenica r)
        {
            tekst.Append(r.GetText());
        }

        public override string GetText()
        {
            return tekst.ToString() + " \n";
        }

        public override string ToString()
        {
            return vrsta + ": " + tekst;
        }
    }

    class GrafickiElement:ElementUDokumentu
    {
        string Boja;
        public string boja { get { return Boja; } set { Boja = value; } }

        public GrafickiElement(string v, string b):base(v)
        {
            boja = b;
        }
    }

    class Pravougaonik:GrafickiElement
    {
        int x1 { get; set; }
        int x2 { get; set; }
        int y1 { get; set; }
        int y2 { get; set; }

        public Pravougaonik(string b, int x1, int x2, int y1, int y2):base("pravougaonik", b)
        {
            this.x1 = x1;
            this.x2 = x2;
            this.y1 = y1;
            this.y2 = y2;
        }

        public override string ToString()
        {
            return vrsta+": "+boja+"(" + x1 + "," + y1 + ")," + (x2 - x1) + "," + (y2 - y1);
        }
    }

    class Dokument
    {
        List<GrafickiElement> graf = new List<GrafickiElement>();
        List<TekstualniElement> teks = new List<TekstualniElement>();

        public void AddElement(GrafickiElement g)
        {
            graf.Add(g);
        }

        public void AddElement(TekstualniElement t)
        {
            teks.Add(t);
        }

        public void PrintText()
        {
            foreach(TekstualniElement t in teks)
            {
                Console.WriteLine(t.GetText());
            }
        }

        public List<TekstualniElement> GetTextElements()
        {
            return teks;
        }

        public override string ToString()
        {
            string t = "";
            string g = "";

            foreach (GrafickiElement gr in graf)
            {
                g += gr.ToString() + "\n\n";
            }

            foreach (TekstualniElement tx in teks)
            {
                t += tx.ToString() + "\n\n";
            }

            return t + g;
        }
    }
}
